import Modal from 'core/modal';
import $ from 'jquery';
import ajax from 'core/ajax';
import CustomEvents from 'core/custom_interaction_events';

export default class ModalBook extends Modal {
    static TYPE = 'mod_iprsmart/modal_book';
    static TEMPLATE = 'mod_iprsmart/modal_book';


    static SELECTORS = {
        CLOSE_BUTTON: "[data-action='close_button']",
        CONTENT_BLOCK: "[data-action='book_content_block']",
        CLOSE_CROSS: ".close",
        ROOT_MODAL: "[data-region='modal-container']",

    };

    static CONTENT_BLOCK = ModalBook.SELECTORS.CONTENT_BLOCK;

    configure(modalConfig) {
        super.configure(modalConfig);
        ModalBook.CONTENT_BLOCK = ModalBook.SELECTORS.CONTENT_BLOCK;
    }

    registerEventListeners() {
        // Call the registerEventListeners method on the parent class.
        super.registerEventListeners();

        this.getModal().on(CustomEvents.events.activate, ModalBook.SELECTORS.CLOSE_BUTTON, function (e) {
            e.preventDefault();
            e.stopPropagation();
            this.getRoot().trigger('click');
        }.bind(this));
        this.getModal().on(CustomEvents.events.scrollBottom, ModalBook.SELECTORS.CONTENT_BLOCK, function (e) {
            let id = [$(e.currentTarget).attr('data-id')];
            ajax.call([
                {
                    methodname: 'mod_iprsmart_book_content', args: {
                        id: id
                    }
                }
            ])[0].then(function (response) {
                return response;
            }).done(function (response) {
                try {
                    let error = JSON.parse(response['body']).error;
                    if (error && error.code === 404) {
                        let errorMsg = 'Ресурс отсутствует в Вашем пользовании. Обратитесь к администратору.';
                        alert(errorMsg);
                        ModalBook.prototype.getBookResult(errorMsg);
                    }
                } catch (e) {
                    ModalBook.prototype.getBookResult(response['body']);
                }
            }).fail(function (response) {
                alert(response);
            });
        });
        this.getModal().on(CustomEvents.events.activate, ModalBook.SELECTORS.CLOSE_CROSS, function (e) {
            e.preventDefault();
            e.stopPropagation();
            this.getRoot().trigger('click');
        }.bind(this));
        this.getRoot().on(CustomEvents.events.activate, function (e) {
            let root = $(ModalBook.SELECTORS.ROOT_MODAL);
            if (root.length > 1) { // потому что эта модалка иногда вторая (после поиска), а иногда первая, внутри модуля.
                root = root[1];    // Костыль, но что делать
            } else {
                root = root[0];
            }
            if (e.target === root) {
                this.getRoot().remove();
            }
            return true;
        }.bind(this));
    }


    static getBookResult =  (response) => {
        let iframeBook = document.getElementById('book_iframe');
        iframeBook.contentWindow.document.open();
        iframeBook.contentWindow.document.write(response);
        iframeBook.contentWindow.document.close();
    };
}
