import $ from 'jquery';
import CustomEvents from 'core/custom_interaction_events';
import ModalBook from "./modal_book";

export const init = (e, id = null, page = null, type = 'book') => {
    let trigger = $(e.currentTarget);
    if (!id) {
        id = $(trigger).closest('.item-container').find('.item').attr('data-id');
    }
    let pageNumber = page ?? $(trigger).closest('.item-container').find('.item').attr('data-page');
    const modal = ModalBook.create({removeOnClose: true});
    modal.then((resolve) => {
        const modalRoot = resolve.getRoot();
        $(ModalBook.CONTENT_BLOCK).attr('data-id', id);
        $(modalRoot).find(ModalBook.CONTENT_BLOCK).attr('data-id', id);
        $(modalRoot).find('.modal-dialog').css('max-width', '1500px');
        $(modalRoot).find('.modal-body').css('height', '770px');
        $(modalRoot).find('.modal-body').css('overflow-y', 'auto');
        $(modalRoot).find(ModalBook.CONTENT_BLOCK).trigger('cie:scrollBottom');
    });
    $(trigger).on(CustomEvents.events.activate, () => {
        modal.then((resolve) => {
            resolve.show();
        });
    });
};
