import Modal from 'core/modal';
import $ from 'jquery';
import ajax from 'core/ajax';
import CustomEvents from 'core/custom_interaction_events';

export default class ModalSearch extends Modal {


    static SELECTORS = {
        SEARCH_TEXTBOX: "[data-action='search_text']",
        START_SEARCH: "[data-action='search_button']",
        START_SEARCH_CLEAR: "[name='clear_search']",
        CANCEL_BUTTON: "[data-action='cancel_button']",
        CONTENT_BLOCK: "[data-action='content_block']",
        CONTENT_NAME: "[name='content_name']",
        TRIGGER_BOOK: ".trigger_book",
        ADD_BOOK: "[name='add_book']",
        CATEGORY_BUTTON: "[data-action='category_tree']",
        CATEGORY_BLOCK: "[data-action='categories']",
        BOOK_PAGINATION: "#books_pagination li.page-item",
        START_PAGE_CLASS: "page-start",
        END_PAGE_CLASS: "page-end",
        PROGRESS: ".loader",
    };
    static LIMIT_ON_PAGE = 10;

    static TYPE = 'mod_iprsmart/modal_search';

    static TEMPLATE = 'mod_iprsmart/modal_search';



    configure(modalConfig) {
        modalConfig.removeOnClose = false;
        super.configure(modalConfig);
    }

    registerEventListeners() {

        super.registerEventListeners();

        const disabledEnterSubmit =  (e) => {
            if (e.keyCode === 13) {
                submitFunction(e);
                return false;
            }
        };
        const disabledKeyUp =  (e) => {
            if (e.keyCode !== false) {
                e.preventDefault();
                return false;
            }
        };
        const submitFunction =  (e) => {
            $.fn.serializeAssoc = function () {
                var data = {};
                $.each(this.serializeArray(), function (key, obj) {
                    var a = obj.name.match(/(.*?)\[(.*?)\]/);
                    if (a !== null) {
                        var subName = a[1];
                        var subKey = a[2];

                        if (!data[subName]) {
                            data[subName] = [];
                        }

                        if (!subKey.length) {
                            subKey = data[subName].length;
                        }

                        if (data[subName][subKey]) {
                            if ($.isArray(data[subName][subKey])) {
                                data[subName][subKey].push(obj.value);
                            } else {
                                data[subName][subKey] = [];
                                data[subName][subKey].push(obj.value);
                            }
                        } else {
                            data[subName][subKey] = obj.value;
                        }
                    } else {
                        if (data[obj.name]) {
                            if ($.isArray(data[obj.name])) {
                                data[obj.name].push(obj.value);
                            } else {
                                data[obj.name] = [];
                                data[obj.name].push(obj.value);
                            }
                        } else {
                            data[obj.name] = obj.value;
                        }
                    }
                });
                return data;
            };
            e.preventDefault();
            e.stopPropagation();
            let id = $(ModalSearch.SELECTORS.CATEGORY_BLOCK).attr('data-id');
            let args = {
                searchParam: $(e.target.form).serializeAssoc(),
                page: 1,
                limit: ModalSearch.LIMIT_ON_PAGE,
                catId: id
            };
            $(ModalSearch.SELECTORS.PROGRESS).toggleClass('hide');
            ModalSearch.getAjaxCall('mod_iprsmart_search_books', args, ModalSearch.getSearchResult)
                .then(function () {
                    ModalSearch.resetPagination();
                    $(ModalSearch.SELECTORS.PROGRESS).toggleClass('hide');
                });
        };

        const getCategoryTree =  (e) => {
            e.preventDefault();
            e.stopPropagation();
            let categoryId = [null];
            let args = {
                categoryId: categoryId
            };
            ModalSearch.getAjaxCall('mod_iprsmart_category_tree', args, ModalSearch.printCategories);
        };

        const setPagination =  (e) => {
            if ($(e.currentTarget).hasClass('disabled')) {
                return true;
            }
            let page, maxPage;
            if ($(ModalSearch.SELECTORS.CONTENT_BLOCK).attr('data-page') === undefined) {
                maxPage = 0;
            } else {
                maxPage = parseInt($(ModalSearch.SELECTORS.CONTENT_BLOCK).attr('data-page'));
            }
            if ($(e.currentTarget).hasClass(ModalSearch.SELECTORS.START_PAGE_CLASS)) {
                if (maxPage > 0) {
                    page = 1;
                } else {
                    page = 0;
                }
            } else if ($(e.currentTarget).hasClass(ModalSearch.SELECTORS.END_PAGE_CLASS)) {
                page = maxPage;
            } else {
                page = parseInt($(e.currentTarget).attr('data-page'));
            }
            let id = $(ModalSearch.SELECTORS.CATEGORY_BLOCK).attr('data-id');
            let args = {
                searchParam: {'searchString': $(ModalSearch.SELECTORS.SEARCH_TEXTBOX).val()},
                page: page,
                limit: ModalSearch.LIMIT_ON_PAGE,
                catId: id
            };
            let prevPage = $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.prev').closest('li.page-item');
            let nextPage = $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.next').closest('li.page-item');
            let currentPage = $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.active').closest('li.page-item');
            if (page >= 2) {
                $(prevPage).attr('data-page', page - 1);
                $(prevPage).removeClass('disabled');
            } else if (page === 1) {
                $(prevPage).attr('data-page', page - 1);
                $(prevPage).addClass('disabled');
            }
            if (maxPage === page) {
                $(nextPage).addClass('disabled');
            } else {
                $(nextPage).removeClass('disabled');
            }
            $(nextPage).attr('data-page', page + 1);
            $(currentPage).attr('data-page', page);
            $(currentPage).find('a.active').text(page + ' из ' + maxPage);
            if (page !== 0 && maxPage !== 0) {
                ModalSearch.getAjaxCall('mod_iprsmart_search_books', args, ModalSearch.getSearchResult);
            }
        };

        this.getModal().on(CustomEvents.events.activate, ModalSearch.SELECTORS.START_SEARCH, submitFunction.bind(this));
        this.getModal().on('click', ModalSearch.SELECTORS.START_SEARCH_CLEAR, function (e) {
            e.preventDefault();
            e.stopPropagation();
            $(ModalSearch.SELECTORS.SEARCH_TEXTBOX).val('');
            $(ModalSearch.SELECTORS.START_SEARCH).trigger('click');
            return false;
        });
        this.getModal().on('keypress', ModalSearch.SELECTORS.SEARCH_TEXTBOX, disabledEnterSubmit.bind(this));
        this.getModal().on(CustomEvents.events.activate, ModalSearch.SELECTORS.BOOK_PAGINATION, setPagination.bind(this));
        this.getModal().on('keydown', ModalSearch.SELECTORS.CONTENT_NAME, disabledKeyUp.bind(this));

        this.getModal().on(CustomEvents.events.activate, ModalSearch.SELECTORS.CANCEL_BUTTON, function () {
            $(this).trigger('hide');
        }.bind(this));

        this.getModal().on(CustomEvents.events.activate, ModalSearch.SELECTORS.CATEGORY_BUTTON, getCategoryTree.bind(this));
    }



    static getSearchResult =  (response) => {
        console.log('Вошёл в getSearchResult');
        $(ModalSearch.SELECTORS.CONTENT_BLOCK).empty();
        let maxPage = Math.ceil(response.total / ModalSearch.LIMIT_ON_PAGE);

        if (response.total > 0) {
            $.each(response.data, function (number, item) {
                let descriptionBlock =
                    '<a class="" data-toggle="collapse" href="#collapseDescription' + item.id + '" role="button">' +
                    'Подробнее об издании' +
                    '</a><br>' +
                    '<div class="collapse" id="collapseDescription' + item.id + '">' +
                    '<span><strong>Описание: </strong>' + item.description + '</span><br><br>' +
                    '<span><strong>Ключевые слова: </strong>' + item.keywords + '</span><br><br>' +
                    '</div>';

                if (item.description === null || item.description === '') {
                    item.description = '';
                    descriptionBlock = '';
                }
                if (item.authors === null || item.authors === '') {
                    item.authors = '';
                }
                $(ModalSearch.SELECTORS.CONTENT_BLOCK).append(
                    '<div class="row" data-id="' + item.id + '">' +
                    '<div class="col-sm-2" >' +
                    '<img src="' + item.image + '" class="img-responsive thumbnail" alt="">' +
                    '</div>' +
                    '<div class="col-sm-8">' +
                    '<span class="book_title" data-val="' + item.title + '"><strong>Название: </strong>' +
                    item.title + '</span><br>' +
                    '<span class="book_authors" data-val="' + item.authors + '"><strong>Авторы: </strong>' +
                    item.authors + '</span><br>' +
                    '<span><strong>Издательство: </strong>' + item.pubhouse + '</span><br>' +
                    '<span><strong>Год издания: </strong>' + item.pubyear + '</span><br>' +
                    '<span><strong>Тип издания: </strong>' + item.pubtype + '</span><br><br>' +
                    '<span class="book_title_additional" style="display: none" data-val="' + item.title_additional + '">' +
                    item.title_additional + '</span><br><br>' +
                    descriptionBlock +
                    '</div>' +
                    '<div class="col-sm-2">' +
                    '<button type="button" name="add_book" class="btn btn-sm" style="color: #0F7DFF;' +
                    'background-color: white;border-color: #0F7DFF;width: 140px;">Добавить</button>' +
                    '<button type="button" class="trigger_book btn btn-sm mt-2" style="color: #0F7DFF;' +
                    'background-color: white;border-color: #0F7DFF;width: 140px;">Предпросмотр</button>' +
                    '<br>' +
                    '</div>' +
                    '</div><hr>');
            });
        } else {
            $(ModalSearch.SELECTORS.CONTENT_BLOCK).append('<div class="item h4">Книги не найдены</div>');
        }
        $(ModalSearch.SELECTORS.CONTENT_BLOCK).attr('data-page', maxPage);
        $(ModalSearch.SELECTORS.TRIGGER_BOOK).on('click', function (e) {
            let bookId = $(e.target).closest('.row').attr('data-id');
            let args = {
                bookId: bookId,
            };

            ModalSearch.getAjaxCall('mod_iprsmart_book_read_url', args, function (response) {
                var win = window.open(response.data, '_blank');
                win.focus();
            });
        });
        $(ModalSearch.SELECTORS.ADD_BOOK).on('click', function (e) {
            let id = $(e.target).closest('.row').attr('data-id');
            let contentName = $('[name="content_name"]');
            contentName.val($(e.target).closest('.row').find('.book_title').attr('data-val'));
            contentName.removeClass('is-invalid');
            contentName.siblings('#id_error_content_name').text('');

            let resName = $('[name="name"]');
            let resAuthors = $(e.target).closest('.row').find('.book_authors').attr('data-val').split(",");
            let resTitle = $(e.target).closest('.row').find('.book_title').attr('data-val');
            let resType = $(e.target).closest('.row').find('.book_title_additional').attr('data-val');
            resName.val(resAuthors[0] + ', ' + resTitle + ": " + resType);
            resName.removeClass('is-invalid');
            resName.siblings('#id_error_content_name').text('');

            $('[name="content"]').val(id);
            $(ModalSearch.SELECTORS.CANCEL_BUTTON).trigger('click');
        });
        console.log('Вышел из getSearchResult');

    };

    static printCategories = (response) => {
        console.log('response = ');
        console.log(response);
        $(ModalSearch.SELECTORS.CATEGORY_BLOCK).empty();
        $.each(response.data, function (number, item) {
            $(ModalSearch.SELECTORS.CATEGORY_BLOCK).append(
                '<div style="cursor:pointer;color:#174c8d;background-color:white;" ' +
                'class="item btn-sm' + (item.count < 0 ? ' bg-primary' : '') + '" data-id="' + item.code + '">' +
                '<span>' + item.name +
                (item.count >= 0 ? ' (' + item.count + ')' : '') +
                '</span>' +
                '</div>');

            $(ModalSearch.SELECTORS.CATEGORY_BLOCK).find('[data-id="' + item.code + '"]').click({item: item}, function (e) {
                e.stopPropagation();
                e.preventDefault();
                $(ModalSearch.SELECTORS.CATEGORY_BLOCK).attr('data-id', $(e.currentTarget).attr('data-id'));

                if (!$(this).hasClass('bg-primary')) {
                    $(this).addClass('bg-primary');
                    $(this).siblings().removeClass('bg-primary');
                }

                $(ModalSearch.SELECTORS.START_SEARCH).trigger('click');
            });
            // ModalSearch.getAjaxCall('mod_iprsmart_category_tree', args, ModalSearch.printCategories);
        });

        $(ModalSearch.SELECTORS.CATEGORY_BLOCK).prepend(
            '<div ' + 'class="btn-sm">' +
            '<h5>УГНП</h5>' +
            '</div>'
        );
    };

    static getAjaxCall =  (methodname, args, callback) => {
        return ajax.call([
            {
                methodname: methodname,
                args,
            }
        ])[0].then(function (response) {
            return response;
        }).done(function (response) {
            let body = JSON.parse(response['body']);
            if (body.success) {
                callback(body);
            } else {
                alert(body.message);
            }
            return true;
        }).fail(function () {
            return false;
        });
    };

    static preloadModalData =  () => {
        let categoryId = [null];
        let args = {
            categoryId: categoryId
        };
        ModalSearch.getAjaxCall('mod_iprsmart_category_tree', args, function (response) {
            ModalSearch.printCategories(response);
            $(ModalSearch.SELECTORS.START_SEARCH).trigger('click');
        });
    };

    static resetPagination =  () => {
        let maxPage = parseInt($(ModalSearch.SELECTORS.CONTENT_BLOCK).attr('data-page'));
        $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.prev').closest('li.page-item').addClass('disabled');
        $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.prev').closest('li.page-item').attr('data-page', 0);
        $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.active').closest('li.page-item').attr('data-page', 1);
        $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.next').closest('li.page-item').attr('data-page', 2);
        if (maxPage > 1) {
            $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.active').text(1 + ' из ' + maxPage);
            $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.next').closest('li.page-item').removeClass('disabled');
        } else {
            $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.active').text(maxPage + ' из ' + maxPage);
            $(ModalSearch.SELECTORS.BOOK_PAGINATION).find('a.next').closest('li.page-item').addClass('disabled');
        }
    };
}
