<?php

namespace mod_iprsmart\event;

use mod_bigbluebuttonbn\local\helpers\reset;
use restore_iprsmart_activity_structure_step;
use stdClass;

class import_handler
{
    /**
     * @throws \dml_exception
     */
    public static function handle_import($eventdata): void
    {
        global $DB;
        // Получаем ID исходного и целевого курсов
        $sourceCourseId = $eventdata->other['originalcourseid'];
        $destinationCourseId = $eventdata->courseid;
        $table = 'iprsmart';
        // Теперь добавляем логику для переноса книг из вашего плагина
        // Например, предположим, что ваш плагин хранит информацию о книгах в таблице 'mybookplugin_books'
        // и каждая книга связана с курсом по его ID
        $books = $DB->get_records($table, ['course' => $sourceCourseId]); // Получаем книги из исходного курса
        // Переносим книги в новый курс
        foreach ($books as $book) {
            $oldBookId = $book->id;
            $book->id = null;
            $book->course = $destinationCourseId; // Устанавливаем новый ID курса
            $book->timecreated = time();
            $DB->insert_record($table, $book); // Создаем копию книги в новом курсе
            $module = $DB->get_field('modules','id',array('name' => 'iprsmart'));
            $sql = "SELECT * FROM {" . $table . "} ORDER BY id DESC LIMIT 1";
            $lastBook = $DB->get_record_sql($sql);
            $newBookId = $lastBook->id;
            // Создаем новую запись для вставки
            $course_modules = $DB->get_records('course_modules',['module' => $module,'instance' => $oldBookId,'course' => $sourceCourseId]);

            $course_module = reset($course_modules);
            $course_module->course = $destinationCourseId; // ID курса, к которому относится книга
            $course_module->instance = $newBookId;
            $course_module->added = time();
            $course_module->id = null;

            $sourceSectionId = $DB->get_field('course_sections','section',['id' => $course_module->section]);

            $sections = $DB->get_records('course_sections',['course' => $destinationCourseId,'section' => $sourceSectionId]);
            $section = reset($sections);

            $course_module->section = $section->id;
            $DB->insert_record('course_modules', $course_module);
            $sequence = $section->sequence;

            $sql = "SELECT id FROM mdl_course_modules ORDER BY id DESC LIMIT 1";
            $lastCourseModule = $DB->get_record_sql($sql);
            $lastCourseModuleId = $lastCourseModule->id;
            if(strlen($sequence)<2){
                $section->sequence = $lastCourseModuleId;
            }
            else{
                $section->sequence = $sequence.','.$lastCourseModuleId;
            }
            $DB->update_record('course_sections',$section);
        }
        purge_all_caches();
    }
}
