<?php

use Firebase\JWT\JWT;

header('Access-Control-Allow-Origin: *');

defined('MOODLE_INTERNAL') || die();

require_once('../../config.php');
require_once($CFG->libdir . "/externallib.php");
require_once($CFG->dirroot . "/webservice/lib.php");
require_once($CFG->libdir . "/filelib.php");



class mod_iprsmart_external extends external_api
{


    const HOST = 'https://api.iprbooks.ru';
    const X_API_KEY = 'pG7xLieVraKMHksK';


    public static function book_content($id, $mobile)
    {
        if (isset($_SESSION['mod_iprsmart_readerToken']) && !empty($_SESSION['mod_iprsmart_readerToken'])) {
            self::$readerToken = $_SESSION['mod_iprsmart_readerToken'];
        }
        if (isset($_SESSION['mod_iprsmart_subscriberToken']) && !empty($_SESSION['mod_iprsmart_subscriberToken'])) {
            self::$subscribeToken = $_SESSION['mod_iprsmart_subscriberToken'];
        }
        $curl = new curl();
        $options = array(
            'CURLOPT_POST'              => false,
            'CURLOPT_SSL_VERIFYPEER'    => true,
            'CURLOPT_RETURNTRANSFER'    => true,
            'CURLOPT_USERAGENT'         => 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36');
        $curl->setopt($options);
        $curl->setopt([ 'CURLOPT_HTTPHEADER' =>
                ['x-auth-token-subscriber: '.self::$subscribeToken,
                    'Authorization: Bearer '.self::$readerToken]
            ]
        );
        if ($mobile) {
            $readerUrl = self::$mobileReaderUrl . '/old/book/'. $id . '?moodle=1';
        } else {
            $readerUrl = self::$readerUrl . '/old/book/'. $id . '?moodle=1';
        }
        //$data = $curl->get($readerUrl, null, $options);
        //$result = self::regexReplace($data);
        return array(
            'body' => self::$readerToken//$result
        );
    }

    public static function book_content_parameters()
    {
        return new \core_external\external_function_parameters(
            array(
                'id' => new \core_external\external_value(PARAM_TEXT, 'book ID'),
                'mobile' => new \core_external\external_value(PARAM_BOOL, 'Do you need a mobile reader')
            )
        );
    }

    public static function book_content_returns() {
        return new external_single_structure(
            array(
                'id' => new external_value(PARAM_INT, 'ID of the book'),
                'title' => new external_value(PARAM_TEXT, 'Title of the book'),
                'title_additional' => new external_value(PARAM_TEXT, 'Additional title'),
                'pubhouse' => new external_value(PARAM_TEXT, 'pubhouse'),
                'authors' => new external_value(PARAM_TEXT, 'authors'),
                'liability' => new external_value(PARAM_INT, 'liability'),
                'pubyear' => new external_value(PARAM_INT, 'pubyear'),
                'description' => new external_value(PARAM_RAW, 'description'),
                'pubtype' => new external_value(PARAM_TEXT, 'pubtype'),
                'addit_subscribe' => new external_value(PARAM_TEXT, 'addit_subscribe'),
                'url' => new external_value(PARAM_TEXT, 'url'),
                'image' => new external_value(PARAM_TEXT, 'image'),
                'score' => new external_value(PARAM_FLOAT, 'score'),
            )
        );
    }




    public static function search_books_parameters()
    {
        return new external_function_parameters(
            array(
                'searchParam' => new external_single_structure(
                    array('searchString' => new external_value(PARAM_TEXT, 'Поисковая строка'),)
                ),
                'page' => new external_value(PARAM_INT, 'смещение выдачи'),
                'limit' => new external_value(PARAM_INT, 'количеcтво элементов на страницу (10 по дефолту)'),
                'catId' => new external_value(PARAM_RAW, 'ИД категории поиска'),
            )
        );
    }

    public static function search_books_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'Поисковая строка'),
            )
        );
    }

    /**
     * @throws dml_exception
     */
    public static function search_books($searchParam, $page, $limit, $catId)
    {
        $params = array(
            "title" => $searchParam['searchString'],
            "ugnp_code" => $catId == '00' ? '' : $catId,
            "limit" => $limit,
            "offset" => ($page - 1) * $limit
        );
        $response = self::exec("/2.0/resources/books", $params);
        return array('body' => $response);
    }

    /**
     * @throws dml_exception
     */
    public static function exec($apiMethod, array $params): bool|string
    {
        $clientId = get_config('iprsmart', 'user_id');
        $secretKey = get_config('iprsmart', 'token');
        $json = array(
            "client_id" => $clientId,
            "time" => time(),
            "ip" => $_SERVER['SERVER_ADDR']
        );

        $token = JWT::encode($json, $secretKey, 'HS256');

        $params = array_merge(array("client_id" => $clientId), $params);

        if (!empty($params)) {
            $apiMethod = sprintf("%s?%s", $apiMethod, http_build_query($params, '', '&'));
        }

        $headers = array(
            'Authorization: Bearer ' . $token,
            'X-APIKey: ' . self::X_API_KEY,
            'Content-Type: application/x-www-form-urlencoded; charset=utf-8',
            'Accept: application/json'
        );
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($curl, CURLOPT_URL, self::HOST . $apiMethod);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $curlResult = curl_exec($curl);
        if (curl_errno($curl)) {
            return '{"success": false,"message": "Curl error ' . curl_errno($curl) . ': ' . curl_error($curl) . '"}';
        }
        return $curlResult;
    }


    /**
     * @throws dml_exception
     */
    public static function book_read_url($bookId)
    {
        $params = array(
            "email" => $USER->email,
            "fullname" => "",
            "user_type" => 1,
            "publication_id" => $bookId,
            "open_method" => "iframe"
        );
        $data = mod_iprsmart_external::exec("/2.0/security/generateAutoAuthUrl", $params);
        return array('body' => $data);
    }

    public static function book_read_url_parameters()
    {
        return new external_function_parameters(
            array(
                'bookId' => new external_value(PARAM_RAW, 'ИД книги')
            )
        );
    }

    public static function book_read_url_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'ссылка'),
            )
        );
    }

    public static function iprsmart_info_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'iprsmart module object from database'),
            )
        );
    }

    public static function iprsmart_info_parameters() {
        return new external_function_parameters(
            array(
                'bookid' => new external_value(PARAM_INT, 'ID of the book')
            )
        );
    }

    public function iprsmart_info($id)
    {
        global $DB;
        $instance = $DB->get_record('course_modules', array('id' => $id));
        if ($instance) {
            $context = context_course::instance($instance->instance);
            try {
                require_capability('mod/iprsmart:get_tree', $context);
            } catch (Exception $e) {
                return array('body' => 'Permission denied: '.$e->getMessage());
            }
            $info = $DB->get_record('iprsmart', array('id' => $instance->instance));
            $info->visible = $instance->visible;
            $info->idnumber = $instance->idnumber;
            $info->availability = $instance->availability;
            $info->completition = $instance->completition;
            $info->completitionexpected = $instance->completitionexpected;
            try {
                return array('body' => json_encode($info, JSON_THROW_ON_ERROR));
            } catch (JsonException $e) {
                return array('body' => 'Error json_encode: ' . $e->getMessage());
            }
        }
        return array('body' => 'No instance error');
    }

    public static function category_tree_parameters()
    {
        return new external_function_parameters(
            array(
                'categoryId' => new external_single_structure(array(new external_value(PARAM_TEXT, 'ИД книги'))
                )
            )
        );
    }

    public static function category_tree_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'верхние категории'),
            )
        );
    }

    /**
     * @throws dml_exception
     */
    public static function category_tree($categoryId)
    {
        $params = array();
        $response = self::exec("/2.0/resources/sections/ugnps", $params);
        $response = json_decode($response, true);

        $allCategory = array("id" => 0,
            "code" => "00",
            "name" => "Выбрать все",
            "count" => -1
        );
        array_unshift($response['data'], $allCategory);

        return array('body' => json_encode($response));
    }

    public static function level_tree_parameters()
    {
        return new external_function_parameters(
            array(
                'categoryId' => new external_single_structure(array(new external_value(PARAM_TEXT, ''))
                )
            )
        );
    }

    public static function level_tree_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, ''),
            )
        );
    }

    /**
     * @throws dml_exception
     */
    public static function level_tree($id)
    {
        $params = array();
        $response = self::exec("/books/levels", $params);
        $response = json_decode($response, true);

        $allLevels = array("id" => 0,
            "level" => "Выбрать все",
        );
        array_unshift($response['data'], $allLevels);

        return array('body' => json_encode($response));
    }

    public static function auth_parameters()
    {
        return new external_function_parameters([]);
    }

    public static function auth()
    {
        $response = [
            "meta" => [
                "success" => true,
                "message" => ""
            ]
        ];

        return array('body' => json_encode($response));
    }

    public static function auth_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'Результат получения токена читателя')
            )
        );
    }
}
