<?php

defined('MOODLE_INTERNAL') || die();


/**
 * Given a course_module object, this function returns any
 * "extra" information that may be needed when printing
 * this activity in a course listing.
 *
 * See {@link get_array_of_activities()} in course/lib.php
 *
 * @param object $coursemodule
 * @return cached_cm_info info
 * @throws dml_exception
 */
function iprsmart_get_coursemodule_info($coursemodule) {
    global $DB, $PAGE;
    $code = 'require("jquery", function($) {$(".modtype_iprsmart").find("img.activityicon").closest("div").css("background-color", "#fff");});';
    $PAGE->requires->js_amd_inline($code);
    $records = $DB->get_record('iprsmart', array('id'=>$coursemodule->instance),
        'name, timecreated, timemodified, intro,
        introformat, content,
        content_name,page_start,page_end');
    if (!$iprsmart = $DB->get_record('iprsmart', array('id'=>$coursemodule->instance),
        'name, timecreated, timemodified, intro,
        introformat, content,
        content_name,page_start,page_end')) {
        return NULL;
    }

    $info = new cached_cm_info();
    $info->name = $iprsmart->name;
    $info->icon = null;

    return $info;
}


function iprsmart_supports($feature)
{
    switch ($feature) {
        case FEATURE_MOD_INTRO:
            return true;
        default:
            return null;
    }
}

function iprsmart_add_instance($moduleinstance, $mform = null)
{
    try{
    global $DB;
        $moduleinstance->timecreated = time();
        return $DB->insert_record('iprsmart', $moduleinstance);
    } catch (dml_exception $e) {
        error_log( $e->getMessage());
        throw new moodle_exception('Add instance dml exception');
    }
}

/**
 * @throws dml_exception
 */
function iprsmart_update_instance($moduleinstance, $mform = null)
{
    try {
        global $DB;
        $moduleinstance->timemodified = time();
        $moduleinstance->id = $moduleinstance->instance;

        return $DB->update_record('iprsmart', $moduleinstance);
    }
    catch (dml_exception $e){
        error_log('error in lib - '.$e->getMessage());
        throw new dml_exception('dml error in adding instanse');
    }
}

/**
 * @throws dml_exception
 */
function iprsmart_delete_instance($id)
{
    try {
        global $DB;
            $exists = $DB->get_record('iprsmart', array('id' => $id));
            if (!$exists) {
                return false;
            }

            $DB->delete_records('iprsmart', array('id' => $id));
            return true;
        }
        catch (dml_exception $e){
            throw new dml_exception('dml exception');
        }
}

function getIprsmart($course, $section, $module)
{
    $iprsmart = new stdClass();
    $iprsmart->course = $course;
    $iprsmart->timecreated = time();
    $iprsmart->timemodified = time();
    $iprsmart->introeditor = array('text' => '</p></p>', 'format' => 1, 'itemid' => 0);
    $iprsmart->itemid = 0;
    $iprsmart->visible = 1;
    $iprsmart->visibleoncoursepage = 1;
    $iprsmart->cmidnumber = '';
    $iprsmart->availabilityconditionsjson = '{"op":"&","c":[],"showc":[]}';
    $iprsmart->completionunlocked = 1;
    $iprsmart->completion = 1;
    $iprsmart->completionexpected = 0;
    $iprsmart->coursemodule = 0;
    $iprsmart->section = $section;
    $iprsmart->module = $module;
    $iprsmart->modulename = 'iprsmart';
    $iprsmart->instance = 0;
    $iprsmart->add = 'iprsmart';
    $iprsmart->update = 0;
    $iprsmart->return = 0;
    $iprsmart->sr = 0;
    $iprsmart->competencies = array();
    $iprsmart->competency_rule = '0';
    $iprsmart->submitbutton = 'Сохранить и показать';
    return $iprsmart;
}
