<?php

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/course/moodleform_mod.php');


class mod_iprsmart_mod_form extends moodleform_mod
{

    /**
     * @throws coding_exception
     * @throws dml_exception
     */
    public function definition(): void
    {
        global $CFG, $PAGE, $USER,$COURSE;
        $mform = $this->_form;
        $settings = get_config("iprsmart");
        if (!empty($settings->token)) {
            $_SESSION['token'] = $settings->token;
        } else if (isset($USER->profile['mod_iprsmart_token']) && !empty($USER->profile['mod_iprsmart_token'])) {
            $_SESSION['token'] = $USER->profile['mod_iprsmart_token'];
        }

        $PAGE->requires->js_call_amd('mod_iprsmart/modal_search_handle', 'init');

        // Adding the "general" fieldset, where all the common settings are shown.
        $mform->addElement('header', 'general', get_string('general', 'form'));

        // Adding the standard "name" field.
        $mform->addElement('text', 'name', get_string('iprsmartname', 'mod_iprsmart'), array('size' => '64'));

        $mform->addElement('hidden', 'content', '');
        $mform->setType('content', PARAM_TEXT);

        if (!empty($CFG->formatstringstriptags)) {
            $mform->setType('name', PARAM_TEXT);
        } else {
            $mform->setType('name', PARAM_CLEANHTML);
        }

        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');




        // Adding the standard "intro" and "introformat" fields.
        $this->standard_intro_elements();

        $mform->addElement('button', 'modal_show_button', get_string('button_desc', 'mod_iprsmart'));
        $mform->addElement('text', 'content_name', 'Выбранное издание', ['style' => 'width:100%']);
        $mform->setType('content_name', PARAM_TEXT);
        $mform->addRule('content_name', null, 'required', null, 'client');

        $mform->addElement('text', 'page_start', 'Страница c');
        $mform->setType('page_start', PARAM_INT);
        $mform->addRule('page_start', null, 'numeric', null, 'client');

        $mform->addElement('text', 'page_end', 'Страница по');
        $mform->setType('page_end', PARAM_INT);
        $mform->addRule('page_end', null, 'numeric', null, 'client');

        $mform->addHelpButton('modal_show_button', 'iprsmartbutton', 'mod_iprsmart');

        // Add standard elements.
        $this->standard_coursemodule_elements();

        // Add standard buttons.
        $this->add_action_buttons();
    }
}
