<?php

require(__DIR__ . '/../../config.php');
require_once(__DIR__ . '/lib.php');
require_once('externallib.php');

use mod_iprsmart\event\course_module_viewed;

global $USER, $PAGE, $DB, $OUTPUT;
// Course_module ID, or
    $id = optional_param('id', 0, PARAM_INT);

// ... module instance id.
    $l = optional_param('l', 0, PARAM_INT);
    $course = '';
    if ($id) {
        $cm = get_coursemodule_from_id('iprsmart', $id, 0, false, MUST_EXIST);
        if (!$cm) {
            error_log('Coursemodule invalid - ' . $cm);
            throw new moodle_exception('Coursemodule invalid');
        }
        $course = $DB->get_record('course', array('id' => $cm->course), '*', MUST_EXIST);
        $moduleinstance = $DB->get_record('iprsmart', array('id' => $cm->instance), '*', MUST_EXIST);
    } else if ($l) {
        $moduleinstance = $DB->get_record('iprsmart', array('id' => $l), '*', MUST_EXIST);
        $course = $DB->get_record('course', array('id' => $moduleinstance->course), '*', MUST_EXIST);
        $cm = get_coursemodule_from_instance('iprsmart', $moduleinstance->id, $course->id, false, MUST_EXIST);

    } else {
        throw new moodle_exception(get_string('missingidandcmid', 'mod_iprsmart'));
    }

    require_login($course, true, $cm);

    $modulecontext = context_module::instance($cm->id);

    $event = \mod_iprsmart\event\course_module_viewed::create_from_iprsmart($moduleinstance, $modulecontext);

    $event = course_module_viewed::create(array(
        'objectid' => $moduleinstance->id,
        'context' => $modulecontext
    ));
    $event->add_record_snapshot('course', $course);
    $event->add_record_snapshot('iprsmart', $moduleinstance);
    $event->trigger();

    $settings = get_config("iprsmart");
    if (!empty($settings->token)) {
        $_SESSION['subscriberToken'] = $settings->token;
    } else if (isset($USER->profile['mod_iprsmart_token']) && !empty($USER->profile['mod_iprsmart_token'])) {
        $_SESSION['subscriberToken'] = $USER->profile['mod_iprsmart_token'];
    }
    $PAGE->requires->js_call_amd('mod_iprsmart/modal_search_handle', 'init');

    $PAGE->requires->js_call_amd('mod_iprsmart/view_button', 'init', array('title' => 'Просмотр'));

    $PAGE->set_url('/mod/iprsmart/view.php', array('id' => $cm->id));
    $PAGE->set_title(format_string($moduleinstance->name));
    $PAGE->set_heading(format_string($course->fullname));
    $PAGE->set_context($modulecontext);

    echo $OUTPUT->header();

    $dataBook = mod_iprsmart_external::exec("/2.0/resources/books/get/" . $moduleinstance->content, array());
    $dataBook = json_decode($dataBook, true);
    if ($dataBook['success']) {
        $book = $dataBook['data'];
        $params = array(
            "email" => $USER->email,
            "fullname" => "",
            "user_type" => 1,
            "publication_id" => $moduleinstance->content,
            "open_method" => "iframe",
            "page_id" => $moduleinstance->page_start,
        );
        $dataUrl = mod_iprsmart_external::exec("/2.0/security/generateAutoAuthUrl", $params);
        $dataUrl = json_decode($dataUrl, true);
        $url = $dataUrl['data'];

        $comment = "";
        if ($moduleinstance->page_start > 0 && $moduleinstance->page_end > 0) {
            $comment .= 'Читать с ' . $moduleinstance->page_start . ' по ' . $moduleinstance->page_end . ' стр.';
        } elseif ($moduleinstance->page_start > 0) {
            $comment .= 'Читать с ' . $moduleinstance->page_start . ' стр.';
        }
        //Ошибка тут
        echo $OUTPUT->render_from_template("iprsmart/view", array('book' => $book, 'url' => $url, 'comment' => $comment));
    }
    else {
        echo $OUTPUT->render_from_template("iprsmart/error", array('message' => $dataBook['message']));
    }
    echo $OUTPUT->footer();
