<?php

$services = array(
    'lab_iprsmartservice' => array(
        'functions' => array('mod_iprsmart_search_books', 'mod_iprsmart_book_content', 'mod_iprsmart_book_read_url', 'mod_iprsmart_category_tree', 'mod_iprsmart_auth'),
        'requiredcapability' => ['mod_iprsmart:get_tree'],
        'restrictedusers' => 1,
        'enabled' => 1,
        'shortname' => 'iprsmartIntegration',
        'downloadfiles' => 0,
        'uploadfiles' => 0,
    ),
);

$functions = array(
    'mod_iprsmart_search_books' => array(
        'classname' => 'mod_iprsmart_external',
        'methodname' => 'search_books',
        'classpath' => 'mod/iprsmart/externallib.php',
        'description' => 'Получение списка книг',
        'type' => 'read',
        'ajax' => true,
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => array('iprsmart:get_tree')
    ),
    'mod_iprsmart_book_content' => array(
        'classname' => 'mod_iprsmart_external',
        'methodname' => 'book_content',
        'classpath' => 'mod/iprsmart/externallib.php',
        'description' => 'Получение читалки с контентом',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => array('iprsmart:get_tree')
    ),
    'mod_iprsmart_book_read_url' => array(
        'classname' => 'mod_iprsmart_external',
        'methodname' => 'book_read_url',
        'classpath' => 'mod/iprsmart/externallib.php',
        'description' => 'Получение ссылки на книгу',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => array('iprsmart:get_tree')
    ),
    'mod_iprsmart_category_tree' => array(
        'classname' => 'mod_iprsmart_external',
        'methodname' => 'category_tree',
        'classpath' => 'mod/iprsmart/externallib.php',
        'description' => 'Получение дерева категорий',
        'type' => 'read',
        'ajax' => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => array('iprsmart:get_tree'),
    ),
    'mod_iprsmart_auth' => array(
        'classname' => 'mod_iprsmart_external',
        'methodname' => 'auth',
        'classpath' => 'mod/iprsmart/externallib.php',
        'description' => 'Авторизация в ЭБС',
        'type'  => 'read',
        'ajax'  => true,
        'service' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
        'capabilities' => array('iprsmart:get_tree'),
    ),
);