<?php

use Firebase\JWT\JWT;

header('Access-Control-Allow-Origin: *');

defined('MOODLE_INTERNAL') || die();

require_once('../../config.php');
require_once($CFG->libdir . "/externallib.php");
require_once($CFG->dirroot . "/webservice/lib.php");
require_once($CFG->libdir . "/filelib.php");
require_once($CFG->dirroot . '/mod/iprsmart/vendor/autoload.php');


class mod_iprsmart_external extends external_api
{

    const HOST = 'https://api.iprbooks.ru';
    const X_API_KEY = 'pG7xLieVraKMHksK';


    public static function search_books_parameters()
    {
        return new external_function_parameters(
            array(
                'searchParam' => new external_single_structure(
                    array('searchString' => new external_value(PARAM_TEXT, 'Поисковая строка'),)
                ),
                'page' => new external_value(PARAM_INT, 'смещение выдачи'),
                'limit' => new external_value(PARAM_INT, 'количетво элементов на страницу (10 по дефолту)'),
                'catId' => new external_value(PARAM_RAW, 'ИД категории поиска'),
            )
        );
    }

    public static function search_books($searchParam, $page, $limit, $catId)
    {
        $params = array(
            "title" => $searchParam['searchString'],
            "ugnp_code" => $catId == '00' ? '' : $catId,
            "limit" => $limit,
            "offset" => ($page - 1) * $limit
        );
        $response = self::exec("/2.0/resources/books/", $params);
        return array('body' => $response);
    }

    public static function search_books_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'Поисковая строка'),
            )
        );
    }

    public static function book_read_url($bookId)
    {
        $params = array(
            "email" => $USER->email,
            "fullname" => "",
            "user_type" => 1,
            "publication_id" => $bookId,
            "open_method" => "iframe"
        );
        $data = mod_iprsmart_external::exec("/2.0/security/generateAutoAuthUrl", $params);
        return array('body' => $data);
    }

    public static function book_read_url_parameters()
    {
        return new external_function_parameters(
            array(
                'bookId' => new external_value(PARAM_RAW, 'ИД книги'),
            )
        );
    }

    public static function book_read_url_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'ссылка'),
            )
        );
    }

    public static function category_tree_parameters()
    {
        return new external_function_parameters(
            array(
                'categoryId' => new external_single_structure(array(new external_value(PARAM_TEXT, 'ИД книги'))
                )
            )
        );
    }

    public static function category_tree($categoryId)
    {
        $params = array();
        $response = self::exec("/2.0/resources/sections/ugnps", $params);
        $response = json_decode($response, true);

        $allCategory = array("id" => 0,
            "code" => "00",
            "name" => "Выбрать все",
            "count" => -1);
        array_unshift($response['data'], $allCategory);

        return array('body' => json_encode($response));
    }

    public static function category_tree_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'верхние категории'),
            )
        );
    }

    public static function auth_parameters()
    {
        return new external_function_parameters([]);
    }

    public static function auth()
    {
        $response = [
            "meta" => [
                "success" => true,
                "message" => ""
            ]
        ];

        return array('body' => json_encode($response));
    }

    public static function auth_returns()
    {
        return new external_single_structure(
            array(
                'body' => new external_value(PARAM_RAW, 'Результат получения токена читателя')
            )
        );
    }

    public static function exec($apiMethod, array $params)
    {
        $clientId = get_config('iprsmart', 'user_id');
        $secretKey = get_config('iprsmart', 'token');

        $json = array(
            "client_id" => $clientId,
            "time" => time(),
            "ip" => $_SERVER['SERVER_ADDR']
        );

        $token = JWT::encode($json, $secretKey);
        $params = array_merge(array("client_id" => $clientId), $params);

        if (!empty($params)) {
            $apiMethod = sprintf("%s?%s", $apiMethod, http_build_query($params, '', '&'));
        }

        $headers = array(
            'Authorization: Bearer ' . $token,
            'X-APIKey: ' . self::X_API_KEY,
            'Content-Type: application/x-www-form-urlencoded; charset=utf-8',
            'Accept: application/json'
        );

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($curl, CURLOPT_URL, self::HOST . $apiMethod);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $curlResult = curl_exec($curl);

        if (curl_errno($curl)) {
            return Curl::getError('Curl error ' . curl_errno($curl) . ': ' . curl_error($curl), 500);
        }

        return $curlResult;
    }
}
