<?php

defined('MOODLE_INTERNAL') || die();

function iprsmart_supports($feature) {
    switch ($feature) {
        case FEATURE_MOD_INTRO:
            return true;
        default:
            return null;
    }
}

function iprsmart_add_instance($moduleinstance, $mform = null) {
    global $DB;

    $moduleinstance->timecreated = time();

    $id = $DB->insert_record('iprsmart', $moduleinstance);

    return $id;
}

function iprsmart_update_instance($moduleinstance, $mform = null) {
    global $DB;

    $moduleinstance->timemodified = time();
    $moduleinstance->id = $moduleinstance->instance;

    return $DB->update_record('iprsmart', $moduleinstance);
}

function iprsmart_delete_instance($id) {
    global $DB;

    $exists = $DB->get_record('iprsmart', array('id' => $id));
    if (!$exists) {
        return false;
    }

    $DB->delete_records('iprsmart', array('id' => $id));

    return true;
}
